package de.sobek.innovations;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CustomerController {

    private Map<Long, Customer> customers = new HashMap<Long,Customer>();

    @PostMapping("/customers")
    public void createCustomer(@RequestBody Customer customer) {
        long createdId = Math.round(Math.random() * 100000000);
        customer.setId(createdId);
        this.customers.put(createdId, customer);
    }

    @GetMapping("/customers")
    public Collection<Customer> getAllCustomers() {
        return customers.values();
    }

    @GetMapping("/customers/{customerId}")
    public Customer get(@PathVariable Long customerId) {
        if (!customers.containsKey(customerId)) {
            throw new NotFoundException();
        }
        return customers.get(customerId);
    }

    @PutMapping("/customers/{customerId}")
    public void updateCustomer(Long customerId, @RequestBody Customer customer) {
        if (!customers.containsKey(customerId)) {
            throw new NotFoundException();
        }
        this.customers.put(customerId, customer);
    }

    @DeleteMapping("/customers/{customerId}")
    public void deleteCustomer(Long customerId) {
        if (!customers.containsKey(customerId)) {
            throw new NotFoundException();
        }
        this.customers.remove(customerId);
    }

    @ResponseStatus(value = HttpStatus.NOT_FOUND, reason="customer not found")
    public class NotFoundException extends RuntimeException {}
}